
* Create derived variables from the app paradata
**************************************************

/*Number of images the receipt is scanned in	*/
	gen rcpt_prts = 1 if addPhoto1Page==2
	replace rcpt_prts = 2 if addPhoto2Page==2
	replace rcpt_prts = 3 if addPhoto3Page==2
	replace rcpt_prts = 4 if addPhoto3Page==1
	la var rcpt_prts "Number of parts receipt was scanned in"

	
/*Generate day of scan		*/
	local daystrt=tc(21oct2016_00:00:00.000)
	local dayend=`daystrt'+86399999	
	gen day_dv=.

	foreach day of numlist 1/76{
		replace day_dv=`day' if endtime>=`daystrt' & endtime<=`dayend'
		local daystrt=`daystrt'+86400000	
		local dayend=`dayend'+86400000
	}
	la var day_dv "Day of the study in which the the submission took place"

	
/*Generate week of scan	*/
	gen week_dv=1 if day_dv<11
	local wkstrt=11
	local wkend=17
	foreach week of numlist 2/11{
	replace week_dv=`week' if day_dv>=`wkstrt' & day_dv<=`wkend'
	local wkstrt=`wkstrt'+7
	local wkend=`wkend'+7
	}
	la var week_dv "Week of the study in which the submission took place"


/*Generate number of days scanned */
	bysort appid day_dv:  gen dup = cond(_N==1,0,_n)	
	gen day_junk =.
	replace day_junk=1 if dup <2
	by appid: egen totaldays_dv=count(day_junk)
	drop dup day_junk
	la var totaldays_dv "Number of days that the participant submitted something to the app"


/*Generate total number of scans per person	*/
	bysort appid: egen totalsubs_dv=count(appid)
	la var totalsubs_dv "Number of times the participant submitted something to the app"

/*Generate the number of scans per person per week*/
	bysort appid week_dv: egen weekscans_dv=count(appid)
	la var weekscans_dv "Number of times the participant submitted something to the app"
	
